TITLE   'Conduction in a Hollow Cylinder'			{ exa151.pde }
SELECT     						{ Student Version }
   errlim=1e-5     ngrid=1     spectral_colors	
COORDINATES   ycylinder( 'r', 'z')
VARIABLES   temp
DEFINITIONS
   r1=10e-3     r2=50e-3     L=40e-3
   temp2=300     heat=0     k=55                       	{ Magnesium oxide }
   power_m=1e4     fluxd_in=power_m/(2*pi*r1)
   fluxd_r=-k*dr(temp)     fluxd_z=-k*dz(temp)
   fluxd=vector( fluxd_r, fluxd_z)     fluxdm=magnitude( fluxd)
   temp_ex=r1*fluxd_in/k*ln(r2/r)+ temp2
EQUATIONS
   div( fluxd)=heat
BOUNDARIES
region 'domain'
   start(r1,0)  natural(temp)=0   line to (r2,0)
   value(temp)=temp2  line to (r2,L)
   natural(temp)=0   line to (r1,L)
   natural(temp)=-fluxd_in   line to close
PLOTS
   contour( temp)     contour( temp- temp_ex) as ' Error in temp '
   contour( fluxdm)     vector( fluxd) norm
   contour( fluxd_r)     contour( fluxd_z)
END


